package editor;

import game.CustomImageDataII;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

public class PlayingWithRotation {

	private static GraphicsConfiguration gc = null;
	
	public static synchronized GraphicsConfiguration getGC() {
		
		if(gc == null) {
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
		}
		
		return gc;
		
	}
	
	
	public static void writeRotationToFile(int rotationInDegrees, BufferedImage origImage) throws Exception {
		
		BufferedImage rotator = getGC().createCompatibleImage(origImage.getWidth(), origImage.getHeight());
		
		Graphics2D g = (Graphics2D) rotator.getGraphics();
		
		

		Color c = g.getColor();
		
		
		g.setColor(Color.white);
		
		g.fillRect(0, 0, rotator.getWidth(), rotator.getHeight());
		
		g.setColor(c);
		
		
		g.translate(112, 112);
		
		g.rotate(Math.toRadians(rotationInDegrees));

		g.translate(-112, -112);
		

		c = g.getColor();
		
		
		g.setColor(Color.white);
		
		g.fillRect(0, 0, rotator.getWidth(), rotator.getHeight());
		
		g.setColor(c);
		
		g.drawImage(origImage, 0, 0, null);
		
		g.dispose();
		
		
		
		
//		BufferedImage output = getGC().createCompatibleImage(origImage.getWidth(), origImage.getHeight());
//		g = (Graphics2D) rotator.getGraphics();
//		
//		c = g.getColor();
//		g.setColor(Color.white);
//		g.drawRect(0, 0, origImage.getWidth(), origImage.getHeight());
//		g.setColor(c);
//		
//		g.drawImage(rotator, 0, 0, null);
//		g.dispose();
		
		ImageIO.write(rotator, "GIF", new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\aStaticWheel_"+padIntThreeDigits(rotationInDegrees)+".GIF"));
		
		
	}
	
	
	public static String padIntThreeDigits(int origInt) {
		
		String returnValue = Integer.toString(origInt);
		if(returnValue.length() == 1)
			return "00" + returnValue;
		else if(returnValue.length() == 2)
			return "0" + returnValue;
		else
			return returnValue;
		
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		try {
			
			BufferedImage origImage = ImageIO.read(new File("C:\\WFMeltdown\\static wheel.GIF"));// Project\\wfMeltdown\\src\\images
			
			
			for(int i = 0; i < 9; i++) {
				writeRotationToFile((int) Math.floor(i * 2.5), origImage);
			}
			
			
//			System.out.println("done!");
			
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		
	}
	
	
	
	public static void mainOldII(String [] args) {
		
		CustomImageDataII base = new CustomImageDataII(new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\engine base.GIF"), null, null);
		CustomImageDataII pistonRod = new CustomImageDataII(new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\piston rod.GIF"), Color.WHITE, null);
		CustomImageDataII face = new CustomImageDataII(new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\engine face.GIF"), Color.WHITE, null);
		
		
		
		
		
		for(int i = 0; i < 60; i++) {
			drawPiston(base, pistonRod, face, i);
		}
		
//		System.out.println("done");
		
		
		
	}
	
	
	public static void drawPiston(CustomImageDataII base, CustomImageDataII pistonRod, CustomImageDataII face, int index) {
		
		BufferedImage rotator = getGC().createCompatibleImage(base.getDesiredWidth(), base.getDesiredHeight());
		
		Graphics2D g = (Graphics2D) rotator.getGraphics();
		
		
		base.drawObjectFromUpperLeftCorner(g, 0, 0);
		
		int xLoc = (int) (Math.cos(Math.PI * index / 60) * 115) + 116;
		
		pistonRod.drawObjectFromUpperLeftCorner(g, xLoc, 16);
		
		face.drawObjectFromUpperLeftCorner(g, 0, 0);
		
		
		g.dispose();
		
		try {
			ImageIO.write(rotator, "GIF", new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\engine_piston_"+padIntThreeDigits(index)+".GIF"));
		} catch(Exception e) {
//			e.printStackTrace();
		}
	}
	
	
	
	public static void mainEngineAssembler(String [] args) {
		
		
		for(int i = 0; i < 120; i++) {
			drawRawFrame( 3* i, i >= 60 ? (119 - i) : i, i);
		}
		
//		System.out.println("done!");
		
	}
	
	
	public static void drawRawFrame(int indexOfCrank, int indexOfEngine, int indexTotal) {
		
		BufferedImage rotator = getGC().createCompatibleImage(855, 262);
		
		Graphics2D g = (Graphics2D) rotator.getGraphics();
		
		
		
		Color c = g.getColor();	
		
		
		g.setColor(Color.white);
		
		g.fillRect(0, 0, rotator.getWidth(), rotator.getHeight());
		
		g.setColor(c);
		
		
//		System.out.println("about to try to load crank image : " + "C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\crank_" + padIntThreeDigits(indexOfCrank) + ".GIF");
		CustomImageDataII crank = new CustomImageDataII(new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\crank_" + padIntThreeDigits(indexOfCrank) + ".GIF"), null, null);
		
//		System.out.println("about to try to load engine image: " + "C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\engine_piston_" + padIntThreeDigits(indexOfEngine) + ".GIF");
		CustomImageDataII engine = new CustomImageDataII(new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\engine_piston_" + padIntThreeDigits(indexOfEngine) + ".GIF"), null, null);
		
		
		crank.drawObjectFromUpperLeftCorner(g, 0, 0);
		
		engine.drawObjectFromUpperLeftCorner(g, 349, 84);
		
		
		g.dispose();
		
		
		try {
			ImageIO.write(rotator, "GIF", new File("C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\engine_raw_"+padIntThreeDigits(indexTotal)+".GIF"));
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
	}
	
	
}
